//+------------------------------------------------------------------+
//|                                                       TestEA.mq5 |
//|                                  Copyright 2022, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2022, Fxalgebra.com"
#property link      "https://www.mql5.com/en/users/omegajoctan"
#property version   "1.00"
#property strict
#property description "This EA is for Testing the Ridge Regression Algorithm"
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
#define DEBUG_MODE

#include <article 11735\Ridge Regression.mqh>;
#include <article 11735\cross_validation.mqh>;
#include <article 11735\preprocessing.mqh>;

CPreprocessing  pre_processing;
CRidgeregression *ridge_reg;
CLinearRegression *Linear_reg;

CMatrixutils matrix_utils;
CCrossValidation *cross_validation;

matrix _Matrix;
//+------------------------------------------------------------------+
//| Script function                                                  |
//-------------------------------------------------------------------+
int OnStart()
  {
   matrix Matrix = matrix_utils.ReadCsv("NASDAQ_DATA.csv");
//---
   Print("----> Ridge regression");

   ridge_reg = new CRidgeregression(Matrix);
   vector coeff = ridge_reg.L2Norm(0.3,true);
   Linear_reg = new CLinearRegression(Matrix,coeff); //passing the coefficients made by ridge regression
// to the Linear regression model
   double acc =0;

   vector ridge_predictions = Linear_reg.LRModelPred(Matrix,acc); //making the predictions and storing them to a vector
   delete(Linear_reg); //deleting that instance
   Print("----> Linear Regression");
   pre_processing.Standardization(Matrix);
   Linear_reg = new CLinearRegression(Matrix); //new Linear reg instance that gets coefficients by least squares
   vector linear_pred = Linear_reg.LRModelPred(Matrix,acc);
//---   free memory
   delete(Linear_reg);
   delete(ridge_reg);

//---
   ridge_reg = new CRidgeregression(Matrix);
   Print("LOOCV ---> ");
   cross_validation = new CCrossValidation(Matrix,RIDGE_REGRESSION);
   double best_lambda = cross_validation.LeaveOneOut(0,0.01,10);
   Print("Best lambda ",best_lambda);
//---
   delete(ridge_reg);
   delete(cross_validation);

   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
